let player = undefined;
(function () {
    'use strict';

    (function () {

        function httpPost(url, body) {
            var xhr = new XMLHttpRequest();
            xhr.open('post', url);
            xhr.setRequestHeader('accept', '*/*');
            xhr.setRequestHeader('content-type', 'application/json');
            xhr.send(body ? JSON.stringify(body) : undefined);
        }

        function EDI() {
            this.paused = false;
        }

        EDI.prototype.processGalleryName = function (galleryName) {
            return galleryName;
        }

        EDI.prototype.play = function (name, speed = 100, seek = 0) {
            if (this.paused)
                return;

            let scriptName = `${this.processGalleryName(name)}`;
            if (speed != 100) {
                scriptName += `_${speed}`;
            }

            httpPost(`http://localhost:5000/Edi/Play/${scriptName}?seek=${seek}`);
        }

        EDI.prototype.stop = function () {
            httpPost(`http://localhost:5000/Edi/Stop`);
        }

        EDI.prototype.pause = function () {
            httpPost(`http://localhost:5000/Edi/Pause`);
        }

        EDI.prototype.resume = function () {
            httpPost(`http://localhost:5000/Edi/Resume`);
        }

        EDI.prototype.filler = function () {
            if (this.paused)
                return;

            this.play("filler");
        }

        EDI.prototype.home = function () {
            if (this.paused)
                return;

            this.play("home");
        }

        EDI.prototype.homeAndHold = function () {
            this.play("home_loop");
        }

        EDI.prototype.freeze = function () {
            this.paused = true;
        }

        EDI.prototype.continue = function () {
            this.paused = false;
        }

        EDI.prototype.setMaxRange = function (range) {
            httpPost(`http://localhost:5000/Edi/Intensity/${range}`)
        }

        player = new EDI();

    })();
})();