(function () {
    'use strict';

    let currentVideo = null;

    const MoviePicture_loadVideo = Sprite_Picture.prototype.loadVideo;
    Sprite_Picture.prototype.loadVideo = function () {
        MoviePicture_loadVideo.apply(this, arguments);

        let videoState = {
            id: this._pictureId,
            startTime: null,
            speed: 100,
            lastSeekTime: null,
            video: this._pictureName,
            x: this.picture().x(),
            y: this.picture().y(),
            paused: this.bitmap._video.paused,
            opacity: this.picture()._opacity
        };

        console.log('Load video: ', videoState, ' bitmap: ', this.bitmap._video);

        if (videoState.opacity == 255 && (!currentVideo || this._pictureId > currentVideo.id))
            currentVideo = videoState;

        this.bitmap._video.addEventListener(
            'pause',
            function () {
                videoState.paused = true;
                videoState.startTime = null;

                if (currentVideo?.id == this._pictureId) {
                    player.pause();
                }
            }.bind(this)
        );

        this.bitmap._video.addEventListener(
            'playing',
            function () {
                console.log('Playing video: ', videoState, 'current: ', currentVideo, 'paused: ', this.bitmap._video.paused, 'picture: ', this.picture());
                if (this.picture().opacity == 0)
                    return;

                if (this.bitmap._video.paused)
                    player.pause();

                currentVideo = videoState;

                let videoTimestamp = Math.round(this.bitmap.getCurrentTime() * 1000);
                videoState.startTime = Date.now() - videoTimestamp;
                videoState.lastSeekTime = videoState.startTime;
                player.play(`${videoState.video}`, this.picture().getVideoSpeed(), videoTimestamp);
            }.bind(this)
        );
    }

    let GameScreen_movePicture = Game_Screen.prototype.movePicture;
    Game_Screen.prototype.movePicture = function (pictureId, origin, x, y, scaleX,
        scaleY, opacity, blendMode, duration) {
        GameScreen_movePicture.apply(this, arguments);
        var picture = this.picture(pictureId);
        if (!picture || picture.isVideo() == false)
            return

        console.log('Moving video: ', pictureId, 'opacity:', opacity, 'x:', x, 'y:', y);

        if (opacity == 0 && currentVideo?.id == pictureId) {
            currentVideo.opacity = 0;
            currentVideo = null;
            setTimeout(() => {
                if (!currentVideo)
                    stop();
            }, 500);
        }
        else if (!currentVideo || (pictureId > currentVideo.id && picture.y == currentVideo.y)) {
            console.log('Set current video to: ', picture);
            if (!currentVideo)
                player.pause();

            currentVideo = { id: pictureId, video: picture.name(), speed: picture.getVideoSpeed(), x: x, y: y, lastSeekTime: Date.now(), opacity: opacity };
        }
    }

    const GameScreen_erasePicture = Game_Screen.prototype.erasePicture;
    Game_Screen.prototype.erasePicture = function (pictureId) {
        GameScreen_erasePicture.apply(this, arguments);
        var realPictureId = this.realPictureId(pictureId);
        if (currentVideo?.id != realPictureId)
            return;

        currentVideo = null;
        setTimeout(() => {
            if (!currentVideo)
                stop();
        }, 500);
    };

    const MoviePicture_updateVideoSpeed = Sprite_Picture.prototype.updateVideoSpeed;
    Sprite_Picture.prototype.updateVideoSpeed = function () {
        const prevSpeed = this._speed;
        MoviePicture_updateVideoSpeed.call(this);
        const newSpeed = this._speed;

        if (currentVideo?.id != this._pictureId)
            return;

        let videoState = currentVideo;

        if (prevSpeed && newSpeed != prevSpeed && videoState.id == currentVideo?.id) {
            let currentTime = this.bitmap.getCurrentTime() * 1000;
            let newTime = Math.round(currentTime / newSpeed);

            if (!newTime)
                return;

            currentVideo.speed = this.picture().getVideoSpeed();
            currentVideo.lastSeekTime = Date.now() - newTime;

            player.play(videoState.video, videoState.speed, newTime);
        }
    }

    const Game_Actor_onBattleEnd = Game_Actor.prototype.onBattleEnd;
    Game_Actor.prototype.onBattleEnd = function () {
        Game_Actor_onBattleEnd.call(this);
        stop();
        currentVideo = null;
    }

    nw.Window.get().on('close', () => {
        player.homeAndHold();
        nw.Window.get().close(true);
    });

    const Input_onKeyUp = Input._onKeyUp;
    Input._onKeyUp = function (event) {
        Input_onKeyUp.call(this, event);
        switch (event.keyCode) {
            case 49: // 1
                player.homeAndHold();
                player.freeze();
                break;
            case 50: // 2                    
                player.continue();
                if (currentVideo)
                    player.play(currentVideo.video, currentVideo.speed, Date.now() - currentVideo.lastSeekTime);
                else
                    player.filler();
                break;
            case 53:
                player.setMaxRange(40);
                break;
            case 54:
                player.setMaxRange(100);
                break;
        }
    }

    const stop = function () {
        console.log("Stop");
        player.home();
        setTimeout(() => player.filler(), 500);
    }

    stop();
})();