﻿#Modificado - Douglas 17/04/24 - 11h20

################################################################################
## Initialization
################################################################################

init offset = -1


################################################################################
## Styles
################################################################################

style pink_button:
    outlines [(2, "#ec2098", 0, 0)]
    xanchor 0.5
    yanchor 0.5

style pink_button_4k:
    outlines [(6, "#ec2098", 0, 0)]
    xanchor 0.5
    yanchor 0.5

style texto_dia_black:
    outlines [(1, "#000000", 2, 2)]

style botao_confirma:
    outlines [(2, "#ec2098", 0, 0)]

style botao_voltar:
    outlines [(2, "#cbcbcb", 0, 0)]

style quick_menu_buttons:
    outlines [(2, "#aeaeae", 0, 0)]

style quick_menu_buttons_4k:
    outlines [(6, "#aeaeae", 0, 0)]

style default:
    properties gui.text_properties()
    language gui.language

style input:
    properties gui.text_properties("input", accent=True)
    adjust_spacing False

style hyperlink_text:
    properties gui.text_properties("hyperlink", accent=True)
    hover_underline True

style gui_text:
    properties gui.text_properties("interface")


style button:
    properties gui.button_properties("button")

style button_text is gui_text:
    properties gui.text_properties("button")
    yalign 0.5


style label_text is gui_text:
    properties gui.text_properties("label", accent=True)

style prompt_text is gui_text:
    properties gui.text_properties("prompt")


style bar:
    ysize gui.bar_size
    left_bar Frame("gui/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    xsize gui.bar_size
    top_bar Frame("gui/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    ysize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    xsize gui.scrollbar_size
    base_bar Frame("gui/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    ysize gui.slider_size
    base_bar Frame("gui/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/slider/horizontal_[prefix_]thumb.png"

style vslider:
    xsize gui.slider_size
    base_bar Frame("gui/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/slider/vertical_[prefix_]thumb.png"


style frame:
    padding gui.frame_borders.padding
    background Frame("gui/frame.png", gui.frame_borders, tile=gui.frame_tile)

#style apoiase_button:
    #xpos gui.navigation_xpos
    #yalign 0.85
    #yoffset -30

style apoiase_text:
    #xpos gui.navigation_xpos
    #yalign 0.80
    size 12

style wp:
    background "#FFF"
    left_padding 6
    right_padding 6
    top_padding 6
    bottom_padding 6
    xalign 0.0

style wp_left:
    xsize 30
    ysize 66
    background "celular/wp-balao-left.png"

style wp_right:
    xsize 30
    ysize 66
    background "celular/wp-balao-right.png"

style wpmc:
    background "#e1ffc7"
    left_padding 6
    right_padding 6
    top_padding 6
    bottom_padding 6
    xalign 0.0

style wp_mc_left:
    xsize 30
    ysize 66
    background "celular/wp-balaomc-left.png"

style wp_mc_right:
    xsize 30
    ysize 66
    background "celular/wp-balaomc-right.png"

style celular_msg:
    size 45
    color "#000"
    outlines [(0, "#e1ffc7", 0, 0)]

style celular_msg_mc:
    size 45
    xalign 1.0
    #color "#009688"
    color "#000"
    outlines [(0, "#e1ffc7", 0, 0)]

style tela_texto:
    size 66
    color "#7e7e7e"
    xalign 0.5

style tela_texto_4k:
    size 50
    color "#7e7e7e"
    xalign 0.5
    outlines [(0, "#000000", 3, 3)]

style tela_menu_4k:
    color "#ec2098"
    outlines [(5, "#000000", 3, 3)]

style tela_padrao:
    color "#999"
    xalign 0.5
    yalign 0.5
    xminimum 610
    xmaximum 610
    yminimum 260
    ymaximum 260
    xpadding 20
    ypadding 30
    background Frame("extra/frame_background_600x250.png")

################################################################################
## In-game screens
################################################################################

## Say screen ##################################################################
##
## The say screen is used to display dialogue to the player. It takes two
## parameters, who and what, which are the name of the speaking character and
## the text to be displayed, respectively. (The who parameter can be None if no
## name is given.)
##
## This screen must create a text displayable with id "what", as Ren'Py uses
## this to manage text display. It can also create displayables with id "who"
## and id "window" to apply style properties.
##
## https://www.renpy.org/doc/html/screen_special.html#say

screen say(who, what):
    style_prefix "say"

    window:
        id "window"

        if who is not None:

            window:
                id "namebox"
                style "namebox"
                text who id "who"

        text what id "what"


    ## If there's a side image, display it above the text. Do not display on the
    ## phone variant - there's no room.
    if not renpy.variant("small"):

        add SideImage() xalign 0.0 yalign 1.0 zoom (0.45)

    else:

        add SideImage() xalign 0.0 yalign 1.0

## Make the namebox available for styling through the Character object.
init python:
    config.character_id_prefixes.append('namebox')

style window is default
style say_label is default
style say_dialogue is default
style say_thought is say_dialogue

style namebox is default
style namebox_label is say_label


style window:
    xalign 0.5
    xfill True
    yalign gui.textbox_yalign
    ysize gui.textbox_height

    # background Image("gui/textbox.png", xalign=0.5, yalign=1.0)

style namebox:
    # xpos gui.name_xpos
    xanchor 0.5
    xalign 0.5
    xsize gui.namebox_width
    ypos gui.name_ypos
    ysize gui.namebox_height

    background Frame("gui/namebox.png", gui.namebox_borders, tile=gui.namebox_tile, xalign=gui.name_xalign)
    padding gui.namebox_borders.padding

style say_label:
    properties gui.text_properties("name", accent=True)
    xalign gui.name_xalign
    yalign 0.5

style say_dialogue:
    properties gui.text_properties("dialogue")

    xpos gui.dialogue_xpos
    xsize gui.dialogue_width
    ypos gui.dialogue_ypos


## Input screen ################################################################
##
## This screen is used to display renpy.input. The prompt parameter is used to
## pass a text prompt in.
##
## This screen must create an input displayable with id "input" to accept the
## various input parameters.
##
## https://www.renpy.org/doc/html/screen_special.html#input

screen input(prompt):
    style_prefix "input"

    window:

        vbox:
            xalign gui.dialogue_text_xalign
            # xpos gui.dialogue_xpos
            xsize gui.dialogue_width
            ypos gui.dialogue_ypos

            text prompt style "input_prompt"
            input id "input"

style input_prompt is default

style input_prompt:
    xalign gui.dialogue_text_xalign
    properties gui.text_properties("input_prompt")

style input:
    xalign gui.dialogue_text_xalign
    xmaximum gui.dialogue_width


## Choice screen ###############################################################
##
## This screen is used to display the in-game choices presented by the menu
## statement. The one parameter, items, is a list of objects, each with caption
## and action fields.
##
## https://www.renpy.org/doc/html/screen_special.html#choice

# How long the player has to make a choice in timeout seconds.
default timeout = 5.0

# The label the player is sent to if they fail to make a choice in the time
# allotted. If None, the timeout is disabled.
default timeout_label = None

screen choice(items):
    style_prefix "choice"

    vbox:
        for i in items:
            #textbutton i.caption action i.action

            $ acao = i.kwargs.get("acao", None)

            textbutton i.caption:

                top_padding -10
                #text_color "#FFFFFF"

                if acao == "fala":
                    background "gui/speak.png"
                else:
                    background "gui/speak.png" #None #"gui/button/choice_idle_background.png"
                action i.action

    if timeout_label is not None:

        bar:
            xalign 0.5
            ypos 400
            xsize 740
            value AnimatedValue(old_value=0.0, value=1.0, range=1.0, delay=timeout)

        timer timeout action Jump(timeout_label)


## When this is true, menu captions will be spoken by the narrator. When false,
## menu captions will be displayed as empty buttons.
define config.narrator_menu = True


style choice_vbox is vbox
style choice_button is button
style choice_button_text is button_text

style choice_vbox:
    xalign 0.5
    yalign 0.5
    # ypos 570
    # yanchor 0.5

    spacing gui.choice_spacing

style choice_button is default:
    properties gui.button_properties("choice_button")

style choice_button_text is default:
    properties gui.button_text_properties("choice_button")


## Quick Menu screen ###########################################################
##
## The quick menu is displayed in-game to provide easy access to the out-of-game
## menus.



screen quick_menu():
    # variant "touch"
    # tag quick_menu_tag
    zorder 200

    if show_quick_menu:

        zorder 200

        #frame:

            #xsize 200
        #    xalign 0.0
        #    yalign 0.0
        #    xpadding 10
        #    ypadding 10
        #    background None

        #    text "[musica_nome]" at nome_musica size 15

        vbox:
            style_prefix "quick"

            xalign 1.0
            ypos 50

            spacing 50

            hbox:
                style_prefix "quick"
                spacing 5

                fixed:
                        xpos -940
                        ypos 25

                        # xanchor 1
                        # yanchor 0.5
                        xmaximum 115
                        ymaximum 44

                        imagebutton auto "extra/botao_voltar_%s.webp" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action [Rollback()] #, Call("show_quick_menu")
                        text _("{font=arialbd.ttf}{size=45}{color=#FFFFFF}Voltar{/color}{/size}{/font}") xpos 10 ypos 0 xanchor 0.4 yanchor 0.5 style "quick_menu_buttons_4k"
                        # imagebutton auto "extra/botao_voltar_%s.png" action Rollback()

                fixed:
                        xpos -720
                        ypos 25

                        # xanchor 1
                        # yanchor 0.5
                        xmaximum 115
                        ymaximum 44

                        imagebutton auto "extra/botao_pular_%s.webp" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action Skip() alternate Skip(fast=True, confirm=False)
                        text _("{font=arialbd.ttf}{size=45}{color=#FFFFFF}Pular{/color}{/size}{/font}") xpos 10 ypos 0  xanchor 0.35 yanchor 0.5 style "quick_menu_buttons_4k"
                        # imagebutton auto "extra/botao_pular_%s.png" action Skip() alternate Skip(fast=True, confirm=False)

                fixed:
                        xpos -500
                        ypos 25

                        # xanchor 1
                        # yanchor 0.5
                        xmaximum 115
                        ymaximum 44

                        imagebutton auto "extra/botao_auto1_%s.webp" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action Preference("auto-forward", "toggle") # [ FileSave("continue", confirm=False, newest=True, page="None", cycle=False, slot=False), Notify(save_confirmation)] #ShowMenu("tela_salvar_jogo")

                        text ("{font=arialbd.ttf}{size=45}{color=#FFFFFF}Auto{/color}{/size}{/font}") xpos 10 ypos 0  xanchor 0.35 yanchor 0.5 style "quick_menu_buttons_4k"
                        # imagebutton auto "extra/botao_salvar_%s.png" action [ FileSave("continue", confirm=False, newest=True, page="None", cycle=False, slot=False), ShowMenu("salvar_nuvem") ]

                fixed:
                        xpos -280
                        ypos 25

                        # xanchor 1
                        # yanchor 0.5
                        xmaximum 115
                        ymaximum 44

                        imagebutton auto "extra/botao_salvar_%s.webp" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action ShowMenu("save") # [ FileSave("continue", confirm=False, newest=True, page="None", cycle=False, slot=False), Notify(save_confirmation)] #ShowMenu("tela_salvar_jogo")

                        text _("{font=arialbd.ttf}{size=45}{color=#FFFFFF}Salvar{/color}{/size}{/font}") xpos 10 ypos 0  xanchor 0.35 yanchor 0.5 style "quick_menu_buttons_4k"
                        # imagebutton auto "extra/botao_salvar_%s.png" action [ FileSave("continue", confirm=False, newest=True, page="None", cycle=False, slot=False), ShowMenu("salvar_nuvem") ]

                fixed:
                        xpos -60
                        ypos 25

                        # xanchor 1
                        # yanchor 0.5
                        xmaximum 115
                        ymaximum 44

                        imagebutton auto "extra/botao_carregar_%s.webp" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action ShowMenu("load") # FileLoad("continue", confirm=False, page="None", newest=True, slot=False) #ShowMenu("tela_carregar_jogo")

                        text _("{font=arialbd.ttf}{size=45}{color=#FFFFFF}Carregar{/color}{/size}{/font}") xpos 10 ypos 0  xanchor 0.325 yanchor 0.5 style "quick_menu_buttons_4k"
                        # imagebutton auto "extra/botao_carregar_%s.png" action [ FileLoad("continue", confirm=False, page="None", newest=True, slot=False) ]


                # fixed:
                #     xpos -60
                #     ypos 25

                #     # xanchor 1
                #     # yanchor 0.5
                #     xmaximum 115
                #     ymaximum 44

                #     imagebutton auto "extra/botao_esconder_%s.webp" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action [Hide("say"), Hide("choice"), SetVariable("show_quick_menu", False)]


                #     text _("{font=arialbd.ttf}{size=45}{color=#FFFFFF}Esconder{/color}{/size}{/font}") xpos 0 ypos 0   xanchor 0.5 yanchor 0.5 style "quick_menu_buttons_4k"
                #     # imagebutton auto "extra/botao_esconder_%s.png" action [Hide("say"), Hide("choice"), SetVariable("show_quick_menu", False)]


            hbox:

                xalign 0.97

                vbox:

                    if tempo <= 1:

                        add "extra/tempo_1.png"

                    elif tempo == 2:

                        add "extra/tempo_2.png"

                    else:

                        add "extra/tempo_3.png"

                    #add "extra/tempo_[tempo].png"

                    frame:
                        ypos 10
                        xpos 40
                        xysize (100,100)
                        background Frame("extra/calendario.png")

                        text "[dia]" size 40 xalign 0.5 yalign 0.7 style "texto_dia_black"

                imagebutton auto "extra/celular_menu_%s.webp" action Show("menu_celular")

            if pode_compras:
                imagebutton idle "extra/botao_geiko.webp":
                    ypos -40
                    action OpenURL("https://www.patreon.com/GeikoGames/")
                    xalign 0.98
            else:
                imagebutton idle "extra/botao_geiko.webp":
                    ypos -40
                    action OpenURL("https://discord.gg/eWMJYuJFe5")
                    xalign 0.98

        frame:

            xalign 1.0
            yalign 1.0
            xpadding 10
            ypadding 5
            background None

            imagebutton auto "extra/botao_menu_%s.webp" action ShowMenu("game_menu")

    elif not show_quick_menu and not proibido_salvar:

        imagemap:

            ground "extra/transparent.png"
            hotspot (0, 0, 3840, 2160) focus_mask None action Call("mostrar_janelas")


# screen quick_menu(): #Quick menu padrão renpy

#     ## Ensure this appears on top of other screens.
#     zorder 200

#     if quick_menu:

#         hbox:
#             style_prefix "quick"

#             xalign 0.5
#             yalign 1.0

#             textbutton _("Voltar") action Rollback()
#             textbutton _("Histórico") action ShowMenu('history')
#             textbutton _("Pular") action Skip() alternate Skip(fast=True, confirm=True)
#             textbutton _("Auto") action Preference("auto-forward", "toggle")
#             textbutton _("Salvar") action ShowMenu('save')
#             # textbutton _("Q.Save") action QuickSave()
#             # textbutton _("Q.Load") action QuickLoad()
#             textbutton _("Menu") action ShowMenu('preferences')

#         vbox:
#             style_prefix "quick"

#             xalign 1.0
#             yalign 0

#             spacing 5

#             hbox:
#                 style_prefix "quick"

#                 imagebutton auto "extra/botao_voltar_%s.png" action Rollback()
#                 imagebutton auto "extra/botao_pular_%s.png" action Skip() alternate Skip(fast=True, confirm=False)
#                 imagebutton auto "extra/botao_salvar_%s.png" action [ FileSave("continue", confirm=False, newest=True, page="None", cycle=False, slot=False), ShowMenu("salvar_nuvem") ]
#                 #imagebutton auto "extra/botao_salvar_%s.png" action QuickSave(message=u'Jogo salvo', newest=True)
#                 imagebutton auto "extra/botao_carregar_%s.png" action [ FileLoad("continue", confirm=False, page="None", newest=True, slot=False) ]
#                 imagebutton auto "extra/botao_esconder_%s.png" action [Hide("say"), Hide("choice"), SetVariable("show_quick_menu", False)]

#                 #imagebutton auto "extra/botao_salvar_%s.png" action Call("salvar_jogo")
#                 #imagebutton auto "extra/botao_carregar_%s.png" action Call("carregar_jogo")

#                 #textbutton _("Voltar") action Rollback()
#                 #textbutton _("Auto") action Preference("auto-forward", "toggle")
#                 #textbutton _("Pular") action Skip() alternate Skip(fast=True, confirm=True)
#                 #textbutton _("Menu") action ShowMenu()
#                 #imagebutton auto "extra/botao_voltar_%s.png" action Rollback()
#                 #imagebutton auto "extra/botao_auto_%s.png" action Preference("auto-forward", "toggle")
#                 #imagebutton auto "extra/botao_pular_%s.png" action Skip() alternate Skip(fast=True, confirm=True)
#                 #imagebutton auto "extra/botao_esconder_%s.png" action Hide('say', dissolve)
#                 #imagebutton auto "extra/botao_menu_%s.png" action ShowMenu()

#             hbox:

#                 xalign 0.985

#                 vbox:

#                     if tempo <= 1:

#                         add "extra/tempo_1.png"

#                     elif tempo == 2:

#                         add "extra/tempo_2.png"

#                     else:

#                         add "extra/tempo_3.png"

#                     #add "extra/tempo_[tempo].png"

#                     frame:

#                         xysize (50,50)
#                         background Frame("extra/calendario.png")

#                         text "[dia]" size 20 xalign 0.5 yalign 0.7

#                 imagebutton auto "extra/celular_menu_%s.png" action Show("menu_celular")

#             imagebutton idle "extra/botao_geiko.webp":
#                 action OpenURL("https://www.patreon.com/GeikoGames/")
#                 xalign 0.98

#     frame:
#         xalign 1.0
#         yalign 1.0
#         xpadding 10
#         ypadding 10
#         background None

#         imagebutton auto "extra/botao_menu_%s.png" action ShowMenu("menu_novidades")


## This code ensures that the quick_menu screen is displayed in-game, whenever
## the player has not explicitly hidden the interface.
# init python:
#     config.overlay_screens.append("quick_menu")

default quick_menu = False

style quick_button is default
style quick_button_text is button_text

style quick_button:
    properties gui.button_properties("quick_button")

style quick_button_text:
    properties gui.button_text_properties("quick_button")


################################################################################
## Main and Game Menu Screens
################################################################################

## Navigation screen ###########################################################
##
## This screen is included in the main and game menus, and provides navigation
## to other menus, and to start the game.

screen navigation():

    vbox:

        style_prefix "navigation"

        xpos 400 #gui.navigation_xpos
        ypos 750
        # yalign 0.5

        spacing 40 # gui.navigation_spacing

        if main_menu:

            #textbutton _("Jogar") action Start()

            if persistent.quincy_morte and not persistent.quincy_especial:

                imagebutton auto "extra/botao_quincy_%s.png" action Jump("quincy_morte_evento")

            # if renpy.variant("mobile"):

            #     if not renpy.can_load("None-continue"):

            #         imagebutton auto "extra/botao_novojogo_%s.png" action Start()

            #     else:

            #         imagebutton auto "extra/botao_continuar_%s.png" action [ FileLoad("continue", confirm=False, page="None", newest=True, slot=False) ]

            #         #imagebutton auto "extra/botao_continuar_%s.png" action [ FileLoad("continue", confirm=False, page="None", newest="True") ]

            #         imagebutton auto "extra/botao_novojogo_%s.png" action Start()

            #     #if renpy.loadable("/Android/data/rbgames.celebrity/files/save/_reload-1-LT1.save"):

            #     #    imagebutton auto "extra/botao_continuar_%s.png" action [ FileLoad("_reload-1", confirm=False, page="None", newest="True") ]

            #     #elif renpy.loadable("/Android/data/rbgames.celebrity/files/save/_reload-2-LT1.save"):

            #     #    imagebutton auto "extra/botao_continuar_%s.png" action [ FileLoad("_reload-2", confirm=False, page="None", newest="True") ]

            #     #else:


            fixed:
                # xpos 100
                # ypos 300
                # xanchor 0.5
                # yanchor 0.5
                xmaximum 690
                ymaximum 153

                imagebutton auto "extra/botao_base_%s.png" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action Start()

                text _("{font=arialbd.ttf}{size=65}{color=#FFFFFF}Jogar{/color}{/size}{/font}") style "pink_button_4k"

            fixed:
                # xpos 100
                # ypos 100
                # xanchor 0.5
                # yanchor 0.5
                xmaximum 690
                ymaximum 153

                imagebutton auto "extra/botao_base_%s.png" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action ShowMenu("load")

                text _("{font=arialbd.ttf}{size=65}{color=#FFFFFF}Carregar{/color}{/size}{/font}") style "pink_button_4k"


                # imagebutton auto "extra/botao_continuar_%s.png" action ShowMenu("load")

        else:

            fixed:
                    # xpos 100
                    # ypos 100
                    # xanchor 0.5
                    # yanchor 0.5
                    xmaximum 690
                    ymaximum 153

                    imagebutton auto "extra/botao_base_%s.png" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action ShowMenu("load")

                    text _("{font=arialbd.ttf}{size=65}{color=#FFFFFF}Carregar{/color}{/size}{/font}") style "pink_button_4k"

            fixed:
                    # xpos 100
                    # ypos 100
                    # xanchor 0.5
                    # yanchor 0.5
                    xmaximum 690
                    ymaximum 153

                    imagebutton auto "extra/botao_base_%s.png" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action ShowMenu("save")

                    text _("{font=arialbd.ttf}{size=65}{color=#FFFFFF}Salvar{/color}{/size}{/font}") style "pink_button_4k"
                    # imagebutton auto "extra/botao_salvar_%s.png" action ShowMenu("save")

            #textbutton _("Salvar") action ShowMenu("save")

        # fixed:
        #     # xpos 80
        #     # ypos 300
        #     # xanchor 1
        #     # yanchor 0.5
        #     xmaximum 690
        #     ymaximum 153

        #     if persistent.user_language == "pt":
        #         imagebutton auto "extra/botao_base_en_%s.png" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action [Language("english"), SetVariable('persistent.user_language', "english")]
        #     else:
        #         imagebutton auto "extra/botao_base_en_%s.png" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action [Language(None), SetVariable('persistent.user_language', "pt")]

        #     text _("{font=arialbd.ttf}{size=65}{color=#FFFFFF}Idioma{/color}{/size}{/font}") xanchor 0.7 style "pink_button_4k"


        fixed:
            # xpos 80
            # ypos 300
            # xanchor 1
            # yanchor 0.5
            xmaximum 690
            ymaximum 153

            imagebutton auto "extra/botao_base_%s.png" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action ShowMenu("preferences_1")

            text _("{font=arialbd.ttf}{size=65}{color=#FFFFFF}Preferências{/color}{/size}{/font}") style "pink_button_4k"

        if pode_compras:    
            fixed:
                # xpos 100
                # ypos 100
                # xanchor 0.5
                # yanchor 0.5
                xmaximum 690
                ymaximum 153

                imagebutton auto "extra/botao_base_%s.png" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action OpenURL("https://www.patreon.com/GeikoGames")

                text _("{font=arialbd.ttf}{size=65}{color=#FFFFFF}Jogos Adultos +18{/color}{/size}{/font}") style "pink_button_4k"



        # textbutton _("Controles") action ShowMenu("help")

            ## The quit button is banned on iOS and unnecessary on Android.
            # textbutton _("Sair") action Quit(confirm=not main_menu)
    if pode_compras:
        vbox:

            style_prefix "navigation"

            xpos gui.navigation_xpos
            # xalign 0
            yalign 0.9

            imagebutton auto "extra/patreon_botao_%s.webp":

                style "apoiase_button"

                action OpenURL("https://www.patreon.com/GeikoGames")



style navigation_button is gui_button
style navigation_button_text is gui_button_text

style navigation_button:
    size_group "navigation"
    properties gui.button_properties("navigation_button")

style navigation_button_text:
    properties gui.button_text_properties("navigation_button")


## Main Menu screen ############################################################
##
## Used to display the main menu when Ren'Py starts.
##
## https://www.renpy.org/doc/html/screen_special.html#main-menu

screen main_menu():

    ## This ensures that any other menu screen is replaced.
    tag menu

    style_prefix "main_menu"

    add gui.main_menu_background

    ## This empty frame darkens the main menu.
    frame:
        pass

    ## The use statement includes another screen inside this one. The actual
    ## contents of the main menu are in the navigation screen.
    use navigation

    if gui.show_name:

        vbox:
            text "[config.name!t]":
                style "main_menu_title"

            text "[config.version]":
                style "main_menu_version"


style main_menu_frame is empty
style main_menu_vbox is vbox
style main_menu_text is gui_text
style main_menu_title is main_menu_text
style main_menu_version is main_menu_text

style main_menu_frame:
    xsize 280
    yfill True

    background "gui/overlay/main_menu.png"

style main_menu_vbox:
    xalign 1.0
    xoffset -20
    xmaximum 800
    yalign 1.0
    yoffset -20

style main_menu_text:
    properties gui.text_properties("main_menu", accent=True)

style main_menu_title:
    properties gui.text_properties("title")

style main_menu_version:
    properties gui.text_properties("version")


## Game Menu screen ############################################################
##
## This lays out the basic common structure of a game menu screen. It's called
## with the screen title, and displays the background, title, and navigation.
##
## The scroll parameter can be None, or one of "viewport" or "vpgrid". When
## this screen is intended to be used with one or more children, which are
## transcluded (placed) inside it.

# screen game_menu(title, scroll=None, yinitial=0.0):

#     style_prefix "game_menu"

#     if main_menu:
#         add gui.main_menu_background
#     else:
#         add gui.game_menu_background

#     frame:
#         style "game_menu_outer_frame"

#         hbox:

#             ## Reserve space for the navigation section.
#             frame:
#                 style "game_menu_navigation_frame"

#             frame:
#                 style "game_menu_content_frame"

#                 if scroll == "viewport":

#                     viewport:
#                         yinitial yinitial
#                         scrollbars "vertical"
#                         mousewheel True
#                         draggable True
#                         pagekeys True

#                         side_yfill True

#                         vbox:
#                             transclude

#                 elif scroll == "vpgrid":

#                     vpgrid:
#                         cols 1
#                         yinitial yinitial

#                         scrollbars "vertical"
#                         mousewheel True
#                         draggable True
#                         pagekeys True

#                         side_yfill True

#                         transclude

#                 else:

#                     transclude

#     use navigation

#     #text "Apoie e receba brindes":
#     #    style "apoiase_text"

#     #imagebutton auto "extra/apoiase_botao_%s.png": #action OpenURL("https://apoia.se/celebrity")
#     #        style "apoiase_button"

#     #        action OpenURL("https://apoia.se/celebrity")

#     textbutton _("É essa"):
#         style "return_button"

#         action Return()

#     label title

#     if main_menu:
#         key "game_menu" action ShowMenu("main_menu")


style game_menu_outer_frame is empty
style game_menu_navigation_frame is empty
style game_menu_content_frame is empty
style game_menu_viewport is gui_viewport
style game_menu_side is gui_side
style game_menu_scrollbar is gui_vscrollbar

style game_menu_label is gui_label
style game_menu_label_text is gui_label_text

style return_button is navigation_button
style return_button_text is navigation_button_text

style game_menu_outer_frame:
    bottom_padding 30
    top_padding 120

    background "gui/overlay/game_menu.png"

style game_menu_navigation_frame:
    xsize 280
    yfill True

style game_menu_content_frame:
    left_margin 40
    right_margin 20
    top_margin 10

style game_menu_viewport:
    xsize 920

style game_menu_vscrollbar:
    unscrollable gui.unscrollable

style game_menu_side:
    spacing 10

style game_menu_label:
    xpos 50
    ysize 120

style game_menu_label_text:
    size gui.title_text_size
    color gui.accent_color
    yalign 0.5

style return_button:
    xpos gui.navigation_xpos
    yalign 1.0
    yoffset -30


## About screen ################################################################
##
## This screen gives credit and copyright information about the game and Ren'Py.
##
## There's nothing special about this screen, and hence it also serves as an
## example of how to make a custom screen.

screen about():

    tag menu

    ## This use statement includes the game_menu screen inside this one. The
    ## vbox child is then included inside the viewport inside the game_menu
    ## screen.
    use game_menu(_("Sobre"), scroll="viewport"):

        style_prefix "about"

        vbox:

            label "[config.name!t]"
            text _("Versão [config.version!t]\n")

            ## gui.about is usually set in options.rpy.
            if gui.about:
                text "[gui.about!t]\n"

            # text _("Made with {a=https://www.renpy.org/}Ren'Py{/a} [renpy.version_only].\n\n[renpy.license!t]")


## This is redefined in options.rpy to add text to the about screen.
define gui.about = ""


style about_label is gui_label
style about_label_text is gui_label_text
style about_text is gui_text

style about_label_text:
    size gui.label_text_size


## Load and Save screens #######################################################
##
## These screens are responsible for letting the player save the game and load
## it again. Since they share nearly everything in common, both are implemented
## in terms of a third screen, file_slots.
##
## https://www.renpy.org/doc/html/screen_special.html#save https://
## www.renpy.org/doc/html/screen_special.html#load

#screen save():

#    tag menu

#    use file_slots(_("Salvar"))


#screen load():

#    tag menu

#    use file_slots(_("Continuar"))


screen file_slots(title):

    if not renpy.android:

        default page_name_value = FilePageNameInputValue(pattern=_("Página {}"), auto=_("Saves Automáticos"), quick=_("Outros Saves"))

        use game_menu(title):

            fixed:

                ## This ensures the input will get the enter event before any of the
                ## buttons do.
                order_reverse True

                ## The page name, which can be edited by clicking on a button.
                button:
                    style "page_label"

                    key_events True
                    xalign 0.5
                    action page_name_value.Toggle()

                    input:
                        style "page_label_text"
                        value page_name_value

                ## The grid of file slots.
                grid gui.file_slot_cols gui.file_slot_rows:
                    style_prefix "slot"

                    xalign 0.5
                    yalign 0.5

                    spacing gui.slot_spacing

                    for i in range(gui.file_slot_cols * gui.file_slot_rows):

                        $ slot = i + 1

                        button:
                            action FileAction(slot)

                            has vbox

                            add FileScreenshot(slot) xalign 0.5

                            text FileTime(slot, format=_("{#file_time} %d/%m/%y, %H:%M"), empty=_("espaço vazio")):
                                style "slot_time_text"

                            text FileSaveName(slot):
                                style "slot_name_text"

                            key "save_delete" action FileDelete(slot)

                ## Buttons to access other pages.
                hbox:
                    style_prefix "page"

                    xalign 0.5
                    yalign 1.0

                    spacing gui.page_spacing

                    textbutton _("<") action FilePagePrevious()

                    if config.has_autosave:
                        textbutton _("{#auto_page}A") action FilePage("auto")

                    # if config.has_quicksave:
                        # textbutton _("{#quick_page}Q") action FilePage("quick")

                    ## range(1, 10) gives the numbers from 1 to 9.
                    for page in range(1, 10):
                        textbutton "[page]" action FilePage(page)

                    textbutton _(">") action FilePageNext()


style page_label is gui_label
style page_label_text is gui_label_text
style page_button is gui_button
style page_button_text is gui_button_text

style slot_button is gui_button
style slot_button_text is gui_button_text
style slot_time_text is slot_button_text
style slot_name_text is slot_button_text

style page_label:
    xpadding 50
    ypadding 3

style page_label_text:
    text_align 0.5
    layout "subtitle"
    hover_color gui.hover_color

style page_button:
    properties gui.button_properties("page_button")

style page_button_text:
    properties gui.button_text_properties("page_button")

style slot_button:
    properties gui.button_properties("slot_button")

style slot_button_text:
    properties gui.button_text_properties("slot_button")


## Preferences screen ##########################################################
##
## The preferences screen allows the player to configure the game to better suit
## themselves.
##
## https://www.renpy.org/doc/html/screen_special.html#preferences


screen preferences_1():

    # tag menu

    # use game_menu(_("Configurações"), scroll="viewport"):
    # use game_menu(_("Configurações")):

    tag menu_aba
    predict False
    zorder 99
    modal True

    add "extra/menu_back.jpg" at menu_back

    # use menu_sidebar

    # frame style "menu_conteudo":

    #     vbox:

    #         xalign 0.6
    #         spacing 200

    #         text _("Configure o seu jogo") xalign 0.5 size 95 style "tela_menu_4k"

    #         if renpy.variant("pc"):

    #             hbox:

    #                 spacing 200

    #                 vbox:

    #                     xalign 0.5
    #                     spacing 50

    #                     text _("Exibição")             xalign 0.5 size 80 style "tela_menu_4k"

    #                     hbox:
    #                         xalign 0.5
    #                         spacing 150
    #                         # style_prefix "radio"

    #                         #textbutton _("Janela") action Preference("display", "window")  xsize 500 xanchor 0.5

    #                         textbutton _("Pequeno") action Preference("display", 0.4) xalign 0.5

    #                         textbutton _("Médio") action Preference("display", 0.55) xalign 0.5

    #                         textbutton _("Tela Cheia") action Preference("display", "fullscreen") xalign 0.5# xanchor 0.5

    #                 vbox:

    #                     xalign 0.5
    #                     spacing 50

    #                     text _("Pular") style "tela_menu_4k" xalign 0.5

    #                     hbox:

    #                         style_prefix "check"

    #                         xalign 0.5
    #                         spacing 50

    #                         textbutton _("Texto") action Preference("skip", "toggle")
    #                         textbutton _("Escolhas") action Preference("after choices", "toggle")
    #                         textbutton _("Transições") action InvertSelected(Preference("transitions", "toggle"))

    #         hbox:
    #             style_prefix "slider"
    #             #box_wrap True
    #             #xpos 900
    #             #xanchor 0.5
    #             xalign 0.5
    #             spacing 200

    #             vbox:
    #                 #xsize 1000
    #                 # xpos 400
    #                 #xanchor 0.5
    #                 xalign 0.5
    #                 spacing 50

    #                 label _("Velocidade do Texto") xalign 0.5

    #                 bar value Preference("text speed") xsize 500 xalign 0.5

    #                 label _("Volume da Escrita") xalign 0.5

    #                 bar value Preference("tec volume") xsize 500 xalign 0.5

    #             vbox:
    #                 #xsize 1000
    #                 # xpos 800
    #                 #xanchor 0.5
    #                 xalign 0.5
    #                 spacing 50

    #                 if config.has_music:
    #                     label _("Volume da Música") xalign 0.5

    #                     hbox:
    #                         bar value Preference("music volume") xsize 500 xalign 0.5

    #                 if config.has_sound:

    #                     label _("Volume dos Efeitos Sonoros") xalign 0.5

    #                     hbox:
    #                         bar value Preference("sound volume") xsize 500 xalign 0.5

    #                         if config.sample_sound:
    #                             textbutton _("Test") action Play("sound", config.sample_sound) xalign 0.5


    #                 # if config.has_voice:
    #                 #     label _("Volume das Vozes") xanchor 0.5

    #                 #     hbox:
    #                 #         bar value Preference("voice volume") xanchor 0.5

    #                 #         if config.sample_voice:
    #                 #             textbutton _("Test") action Play("voice", config.sample_voice) xanchor 0.5

    #                 # if config.has_music or config.has_sound or config.has_voice:
    #                 #     null height gui.pref_spacing

    #                 #     textbutton _("Mutar"):
    #                 #         xanchor 0.5
    #                 #         action Preference("all mute", "toggle")
    #                 #         style "mute_all_button"
    #         hbox:
    #             xalign 0.5
    #             spacing 400

    #             vbox:
    #                 xalign 0.5
    #                 spacing 50

    #                 label _("Idioma") xalign 0.5

    #                 hbox:

    #                     style_prefix "radio"

    #                     xalign 0.5
    #                     spacing 50

    #                     textbutton "English" action [Language("english"), SetVariable('persistent.user_language', "english")]
    #                     textbutton "Português" action [Language(None), SetVariable('persistent.user_language', "pt")]

                
    #             vbox:

    #                 xalign 0.5
    #                 spacing 50

    #                 label _("Nomear Saves")

    #                 hbox:

    #                     style_prefix "radio"

    #                     xalign 0.5
    #                     spacing 50

    #                     textbutton _("Sim") action [SetVariable("persistent.saveName", True), SetVariable("store.save_name", "")]
    #                     textbutton _("Não") action [SetVariable("persistent.saveName", False), SetVariable("store.save_name", _("Progresso [slot]"))] #sets a default name, change as required

    #             vbox:
    #                 xalign 0.5
    #                 spacing 50

    #                 label _("Botões de navegação") xalign 0.5

    #                 hbox:

    #                     style_prefix "radio"

    #                     xalign 0.5
    #                     spacing 50

    #                     textbutton "Sempre visível" action [SetVariable("quick_menu_fixo", True)]
    #                     textbutton "Padrão" action [SetVariable("quick_menu_fixo", False)]

    frame style "menu_conteudo":

        vbox:

            xalign 0.6
            spacing 150

            text _("Configure o seu jogo") xalign 0.5 size 95 style "tela_menu_4k"

            if not renpy.variant("android"):

                hbox:

                    spacing 200

                    vbox:

                        xalign 0.5
                        spacing 50

                        text _("Exibição")             xalign 0.5 size 80 style "tela_menu_4k"

                        hbox:
                            xalign 0.5
                            spacing 150
                            # style_prefix "radio"

                            #textbutton _("Janela") action Preference("display", "window")  xsize 500 xanchor 0.5

                            textbutton _("Pequeno") action Preference("display", 0.4) xalign 0.5

                            textbutton _("Médio") action Preference("display", 0.55) xalign 0.5

                            textbutton _("Tela Cheia") action Preference("display", "fullscreen") xalign 0.5# xanchor 0.5

                    vbox:

                        xalign 0.5
                        spacing 50

                        text _("Pular") style "tela_menu_4k" xalign 0.5

                        hbox:

                            style_prefix "check"

                            xalign 0.5
                            spacing 50

                            textbutton _("Texto") action Preference("skip", "toggle")
                            textbutton _("Escolhas") action Preference("after choices", "toggle")
                            textbutton _("Transições") action InvertSelected(Preference("transitions", "toggle"))

            hbox:
                style_prefix "slider"
                #box_wrap True
                #xpos 900
                #xanchor 0.5
                xalign 0.5
                spacing 400

                vbox:
                    xsize 500
                    # xpos 400
                    # xanchor 0.5
                    xalign 0.5
                    spacing 50

                    text _("Velocidade do Texto")  xsize 800 xalign 0.5 textalign 0.5 style "tela_menu_4k"

                    bar value Preference("text speed") xsize 500 xalign 0.5

                    text _("Volume da Escrita")  xsize 800 xalign 0.5 textalign 0.5 style "tela_menu_4k"

                    bar value Preference("tec volume") xsize 500 xalign 0.5

                    text _("Texto Auto")  xsize 800 xalign 0.5 textalign 0.5 style "tela_menu_4k"

                    bar value Preference("auto-forward time") xsize 500 xalign 0.5



                vbox:
                    xsize 500
                    # xpos 800
                    # xanchor 0.5
                    # xmaximum 800
                    xalign 0.5
                    spacing 50

                    if config.has_music:
                        text _("Volume da Música") xsize 800 xalign 0.5 textalign 0.5 style "tela_menu_4k"

                        hbox:
                            bar value Preference("music volume") xsize 500 xalign 0.5

                    if config.has_sound:

                        text _("Volume dos Efeitos Sonoros") xsize 800 xalign 0.5 textalign 0.5 style "tela_menu_4k"

                        hbox:
                            bar value Preference("sound volume") xsize 500 xalign 0.5

                            if config.sample_sound:
                                textbutton _("Test") action Play("sound", config.sample_sound) xalign 0.5


                    # if config.has_voice:
                    #     label _("Volume das Vozes") xanchor 0.5

                    #     hbox:
                    #         bar value Preference("voice volume") xanchor 0.5

                    #         if config.sample_voice:
                    #             textbutton _("Test") action Play("voice", config.sample_voice) xanchor 0.5

                    # if config.has_music or config.has_sound or config.has_voice:
                    #     null height gui.pref_spacing

                    #     textbutton _("Mutar"):
                    #         xanchor 0.5
                    #         action Preference("all mute", "toggle")
                    #         style "mute_all_button"

            hbox:
                xalign 0.5
                spacing 400

                vbox:
                    xalign 0.5
                    spacing 50
                    hbox:
                        xalign 0.5
                        spacing 10
                        text _("Idioma") xalign 0.5 style "tela_menu_4k"
                        imagebutton idle "extra/bandeira_solo.webp" action NullAction() xalign 0.5 yalign 0.5

                    hbox:

                        style_prefix "radio"

                        xalign 0.5
                        spacing 50

                        textbutton "English" action [Language("english"), SetVariable('persistent.user_language', "english")]
                        textbutton "Português" action [Language(None), SetVariable('persistent.user_language', "pt")]

                
                vbox:

                    xalign 0.5
                    spacing 50

                    text _("Nomear Saves")  style "tela_menu_4k"

                    hbox:

                        style_prefix "radio"

                        xalign 0.5
                        spacing 50

                        textbutton _("Sim") action [SetVariable("persistent.saveName", True), SetVariable("store.save_name", "")]
                        textbutton _("Não") action [SetVariable("persistent.saveName", False), SetVariable("store.save_name", _("Progresso [slot]"))] #sets a default name, change as required

                vbox:
                    xalign 0.5
                    spacing 50

                    text _("Botões de navegação") xalign 0.5  style "tela_menu_4k"

                    hbox:

                        style_prefix "radio"

                        xalign 0.5
                        spacing 50

                        textbutton _("Sempre visível") action [SetVariable("quick_menu_fixo", True)]
                        textbutton _("Padrão") action [SetVariable("quick_menu_fixo", False)]



    fixed:
        xpos 400
        ypos 2000
        # ypos 300
        # xanchor 1
        # yanchor 0.5
        # xmaximum 226
        # ymaximum 52

        imagebutton auto "extra/botao_base_%s.png" xpos 0 ypos 0 xanchor 0.5 yanchor 0.5 action Hide("preferences_1")


        text _("{font=arialbd.ttf}{size=40}{color=#FFFFFF}Voltar{/color}{/size}{/font}") style "pink_button_4k"



screen preferences_2():

    # tag menu

    # use game_menu(_("Configurações"), scroll="viewport"):
    # use game_menu(_("Configurações")):

    tag menu_aba
    predict False
    zorder 99
    modal True

    add "extra/menu_back.jpg" at menu_back

    use menu_sidebar

    frame style "menu_conteudo":

        vbox:

            xalign 0.7
            spacing 100

            text _("Configure o seu jogo") xalign 0.5 size 95 style "tela_menu_4k"

            if not renpy.variant("android"):

                hbox:

                    spacing 200

                    vbox:

                        xalign 0.5
                        spacing 50

                        text _("Exibição")             xalign 0.5 size 80 style "tela_menu_4k"

                        hbox:
                            xalign 0.5
                            spacing 150
                            # style_prefix "radio"

                            #textbutton _("Janela") action Preference("display", "window")  xsize 500 xanchor 0.5

                            textbutton _("Pequeno") action Preference("display", 0.4) xalign 0.5

                            textbutton _("Médio") action Preference("display", 0.55) xalign 0.5

                            textbutton _("Tela Cheia") action Preference("display", "fullscreen") xalign 0.5# xanchor 0.5

                    vbox:

                        xalign 0.5
                        spacing 50

                        text _("Pular") style "tela_menu_4k" xalign 0.5

                        hbox:

                            style_prefix "check"

                            xalign 0.5
                            spacing 50

                            textbutton _("Texto") action Preference("skip", "toggle")
                            textbutton _("Escolhas") action Preference("after choices", "toggle")
                            textbutton _("Transições") action InvertSelected(Preference("transitions", "toggle"))

            hbox:
                style_prefix "slider"
                #box_wrap True
                #xpos 900
                #xanchor 0.5
                xalign 0.5
                spacing 400

                vbox:
                    xsize 500
                    # xpos 400
                    # xanchor 0.5
                    xalign 0.5
                    spacing 50

                    text _("Velocidade do Texto")  xsize 800 xalign 0.5 textalign 0.5 style "tela_menu_4k"

                    bar value Preference("text speed") xsize 500 xalign 0.5

                    text _("Volume da Escrita")  xsize 800 xalign 0.5 textalign 0.5 style "tela_menu_4k"

                    bar value Preference("tec volume") xsize 500 xalign 0.5

                    text _("Texto Auto")  xsize 800 xalign 0.5 textalign 0.5 style "tela_menu_4k"

                    bar value Preference("auto-forward time") xsize 500 xalign 0.5

                vbox:
                    xsize 500
                    # xpos 800
                    # xanchor 0.5
                    # xmaximum 800
                    xalign 0.5
                    spacing 50

                    if config.has_music:
                        text _("Volume da Música") xsize 800 xalign 0.5 textalign 0.5 style "tela_menu_4k"

                        hbox:
                            bar value Preference("music volume") xsize 500 xalign 0.5

                    if config.has_sound:

                        text _("Volume dos Efeitos Sonoros") xsize 800 xalign 0.5 textalign 0.5 style "tela_menu_4k"

                        hbox:
                            bar value Preference("sound volume") xsize 500 xalign 0.5

                            if config.sample_sound:
                                textbutton _("Test") action Play("sound", config.sample_sound) xalign 0.5


                    # if config.has_voice:
                    #     label _("Volume das Vozes") xanchor 0.5

                    #     hbox:
                    #         bar value Preference("voice volume") xanchor 0.5

                    #         if config.sample_voice:
                    #             textbutton _("Test") action Play("voice", config.sample_voice) xanchor 0.5

                    # if config.has_music or config.has_sound or config.has_voice:
                    #     null height gui.pref_spacing

                    #     textbutton _("Mutar"):
                    #         xanchor 0.5
                    #         action Preference("all mute", "toggle")
                    #         style "mute_all_button"

            hbox:
                xalign 0.5
                spacing 400

                vbox:
                    xalign 0.5
                    spacing 50
                    hbox:
                        xalign 0.5
                        spacing 10
                        text _("Idioma") xalign 0.5 style "tela_menu_4k"
                        imagebutton idle "extra/bandeira_solo.webp" action NullAction() xalign 0.5 yalign 0.5

                    hbox:

                        style_prefix "radio"

                        xalign 0.5
                        spacing 50

                        textbutton "English" action [Language("english"), SetVariable('persistent.user_language', "english")]
                        textbutton "Português" action [Language(None), SetVariable('persistent.user_language', "pt")]

                
                vbox:

                    xalign 0.5
                    spacing 50

                    text _("Nomear Saves")  style "tela_menu_4k"

                    hbox:

                        style_prefix "radio"

                        xalign 0.5
                        spacing 50

                        textbutton _("Sim") action [SetVariable("persistent.saveName", True), SetVariable("store.save_name", "")]
                        textbutton _("Não") action [SetVariable("persistent.saveName", False), SetVariable("store.save_name", _("Progresso [slot]"))] #sets a default name, change as required

                vbox:
                    xalign 0.5
                    spacing 50

                    text _("Botões de navegação") xalign 0.5  style "tela_menu_4k"

                    hbox:

                        style_prefix "radio"

                        xalign 0.5
                        spacing 50

                        textbutton _("Sempre visível") action [SetVariable("quick_menu_fixo", True)]
                        textbutton _("Padrão") action [SetVariable("quick_menu_fixo", False)]

            hbox:
                xalign 0.5
                ypos 100
                text "v[config.version]" xalign 0.5



style pref_label is gui_label
style pref_label_text is gui_label_text
style pref_vbox is vbox

style radio_label is pref_label
style radio_label_text is pref_label_text
style radio_button is gui_button
style radio_button_text is gui_button_text
style radio_vbox is pref_vbox

style check_label is pref_label
style check_label_text is pref_label_text
style check_button is gui_button
style check_button_text is gui_button_text
style check_vbox is pref_vbox

style slider_label is pref_label
style slider_label_text is pref_label_text
style slider_slider is gui_slider
style slider_button is gui_button
style slider_button_text is gui_button_text
style slider_pref_vbox is pref_vbox

style mute_all_button is check_button
style mute_all_button_text is check_button_text

style pref_label:
    top_margin gui.pref_spacing
    bottom_margin 2

style pref_label_text:
    yalign 1.0

style pref_vbox:
    xsize 225

style radio_vbox:
    spacing gui.pref_button_spacing

style radio_button:
    properties gui.button_properties("radio_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style radio_button_text:
    properties gui.button_text_properties("radio_button")

style check_vbox:
    spacing gui.pref_button_spacing

style check_button:
    properties gui.button_properties("check_button")
    foreground "gui/button/check_[prefix_]foreground.png"

style check_button_text:
    properties gui.button_text_properties("check_button")

style slider_slider:
    xsize 350

style slider_button:
    properties gui.button_properties("slider_button")
    yalign 0.5
    left_margin 10

style slider_button_text:
    properties gui.button_text_properties("slider_button")

style slider_vbox:
    xsize 450


## History screen ##############################################################
##
## This is a screen that displays the dialogue history to the player. While
## there isn't anything special about this screen, it does have to access the
## dialogue history stored in _history_list.
##
## https://www.renpy.org/doc/html/history.html

screen history():

    tag menu

    ## Avoid predicting this screen, as it can be very large.
    predict False

    use game_menu(_("Histórico"), scroll=("vpgrid" if gui.history_height else "viewport"), yinitial=1.0):

        style_prefix "history"

        for h in _history_list:

            window:

                ## This lays things out properly if history_height is None.
                has fixed:
                    yfit True

                if h.who:

                    label h.who:
                        style "history_name"

                        ## Take the color of the who text from the Character, if
                        ## set.
                        if "color" in h.who_args:
                            text_color h.who_args["color"]

                $ what = renpy.filter_text_tags(h.what, allow=gui.history_allow_tags)
                text what

        if not _history_list:
            label _("Você ainda não começou o game :(")


## This determines what tags are allowed to be displayed on the history screen.

define gui.history_allow_tags = set()


style history_window is empty

style history_name is gui_label
style history_name_text is gui_label_text
style history_text is gui_text

style history_text is gui_text

style history_label is gui_label
style history_label_text is gui_label_text

style history_window:
    xfill True
    ysize gui.history_height

style history_name:
    xpos gui.history_name_xpos
    # xanchor gui.history_name_xalign
    ypos gui.history_name_ypos
    xsize gui.history_name_width

style history_name_text:
    min_width gui.history_name_width
    text_align gui.history_name_xalign

style history_text:
    xpos gui.history_text_xpos
    ypos gui.history_text_ypos
    # xanchor gui.history_text_xalign
    xsize gui.history_text_width
    min_width gui.history_text_width
    text_align gui.history_text_xalign
    layout ("subtitle" if gui.history_text_xalign else "tex")

style history_label:
    xfill True

style history_label_text:
    xalign 0.5


## Help screen #################################################################
##
## A screen that gives information about key and mouse bindings. It uses other
## screens (keyboard_help, mouse_help, and gamepad_help) to display the actual
## help.

screen help():

    tag menu

    default device = "keyboard"

    use game_menu(_("Controles")):

        style_prefix "help"

        vbox:
            spacing 15

            hbox:

                textbutton _("Teclado") action SetScreenVariable("device", "keyboard")
                textbutton _("Mouse") action SetScreenVariable("device", "mouse")

                if GamepadExists():
                    textbutton _("Controle") action SetScreenVariable("device", "gamepad")

            if device == "keyboard":
                use keyboard_help
            elif device == "mouse":
                use mouse_help
            elif device == "gamepad":
                use gamepad_help


screen keyboard_help():

    hbox:
        label _("Enter")
        text _("Avança o diálogo e mostra a interface.")

    hbox:
        label _("Espaço")
        text _("Avança o diálogo sem fazer escolhas.")

    hbox:
        label _("Setas")
        text _("Navega pela interface.")

    hbox:
        label _("Esc")
        text _("Abre o menu do jogo.")

    hbox:
        label _("Ctrl")
        text _("Mantenha pressionado para Pular (defina o que pular na aba Opções).")

    hbox:
        label _("Tab")
        text _("Alterna entre as configurações do Pular.")

    hbox:
        label _("Page Up")
        text _("Retorna para o diálogo passado.")

    hbox:
        label _("Page Down")
        text _("Avança para o próximo diálogo já lido.")

    hbox:
        label "H"
        text _("Esconde a interface.")

    hbox:
        label "S"
        text _("Tira uma screenshot.")

    hbox:
        label "V"
        text _("Liga ou desliga a {a=https://www.renpy.org/l/voicing}voz automática de leitura{/a}.")


screen mouse_help():

    hbox:
        label _("LMB (Clique Esquerdo)")
        text _("Avança o diálogo e mostra a interface.")

    hbox:
        label _("MMB (Cique do Meio)")
        text _("Esconde a interface.")

    hbox:
        label _("RMB (Clique Direito)")
        text _("Abre o menu do jogo.")

    hbox:
        label _("Roda do Mouse Para Cima")
        text _("Retorna para o diálogo passado.")

    hbox:
        label _("Roda do Mouse Para Baixo")
        text _("Avança para o próximo diálogo já lido.")


screen gamepad_help():

    hbox:
        label _("Right Trigger\nA/Bottom Button")
        text _("Advances dialogue and activates the interface.")

    hbox:
        label _("Left Trigger\nLeft Shoulder")
        text _("Rolls back to earlier dialogue.")

    hbox:
        label _("Right Shoulder")
        text _("Rolls forward to later dialogue.")


    hbox:
        label _("D-Pad, Sticks")
        text _("Navigate the interface.")

    hbox:
        label _("Start, Guide")
        text _("Accesses the game menu.")

    hbox:
        label _("Y/Top Button")
        text _("Hides the user interface.")

    textbutton _("Calibrate") action GamepadCalibrate()


style help_button is gui_button
style help_button_text is gui_button_text
style help_label is gui_label
style help_label_text is gui_label_text
style help_text is gui_text

style help_button:
    properties gui.button_properties("help_button")
    xmargin 8

style help_button_text:
    properties gui.button_text_properties("help_button")

style help_label:
    xsize 250
    right_padding 20

style help_label_text:
    size gui.text_size
    xalign 1.0
    text_align 1.0



################################################################################
## Additional screens
################################################################################


## Confirm screen ##############################################################
##
## The confirm screen is called when Ren'Py wants to ask the player a yes or no
## question.
##
## https://www.renpy.org/doc/html/screen_special.html#confirm

screen confirm(message, yes_action, no_action):

    ## Ensure other screens do not get input while this screen is displayed.
    modal True

    zorder 200

    style_prefix "confirm"

    add "gui/overlay/confirm.png"

    frame:

        vbox:
            xalign .5
            yalign .5
            spacing 30

            label _(message):
                style "confirm_prompt"
                xalign 0.5

            hbox:
                xalign 0.5
                spacing 100

                textbutton _("Sim") action yes_action
                textbutton _("Não") action no_action

    ## Right-click and escape answer "no".
    key "game_menu" action no_action


style confirm_frame is gui_frame
style confirm_prompt is gui_prompt
style confirm_prompt_text is gui_prompt_text
style confirm_button is gui_medium_button
style confirm_button_text is gui_medium_button_text

style confirm_frame:
    background Frame([ "gui/confirm_frame.png", "gui/frame.png"], gui.confirm_frame_borders, tile=gui.frame_tile)
    padding gui.confirm_frame_borders.padding
    xalign .5
    yalign .5

style confirm_prompt_text:
    text_align 0.5
    layout "subtitle"

style confirm_button:
    properties gui.button_properties("confirm_button")

style confirm_button_text:
    properties gui.button_text_properties("confirm_button")


## Skip indicator screen #######################################################
##
## The skip_indicator screen is displayed to indicate that skipping is in
## progress.
##
## https://www.renpy.org/doc/html/screen_special.html#skip-indicator

screen skip_indicator():

    zorder 100
    style_prefix "skip"

    frame:

        hbox:
            spacing 6

            text _("Pulando")

            text "▸" at delayed_blink(0.0, 1.0) style "skip_triangle"
            text "▸" at delayed_blink(0.2, 1.0) style "skip_triangle"
            text "▸" at delayed_blink(0.4, 1.0) style "skip_triangle"


## This transform is used to blink the arrows one after another.
transform delayed_blink(delay, cycle):
    alpha .5

    pause delay

    block:
        linear .2 alpha 1.0
        pause .2
        linear .2 alpha 0.5
        pause (cycle - .4)
        repeat


style skip_frame is empty
style skip_text is gui_text
style skip_triangle is skip_text

style skip_frame:
    ypos gui.skip_ypos
    background Frame("gui/skip.png", gui.skip_frame_borders, tile=gui.frame_tile)
    padding gui.skip_frame_borders.padding

style skip_text:
    size gui.notify_text_size

style skip_triangle:
    ## We have to use a font that has the BLACK RIGHT-POINTING SMALL TRIANGLE
    ## glyph in it.
    font "DejaVuSans.ttf"


## Notify screen ###############################################################
##
## The notify screen is used to show the player a message. (For example, when
## the game is quicksaved or a screenshot has been taken.)
##
## https://www.renpy.org/doc/html/screen_special.html#notify-screen

screen notify(message):

    zorder 100
    style_prefix "notify"

    frame at notify_appear:
        text "[message!tq]"

    timer 3.25 action Hide('notify')


transform notify_appear:
    on show:
        alpha 0
        linear .25 alpha 1.0
    on hide:
        linear .5 alpha 0.0


style notify_frame is empty
style notify_text is gui_text

style notify_frame:
    ypos gui.notify_ypos

    background Frame("gui/notify.png", gui.notify_frame_borders, tile=gui.frame_tile)
    padding gui.notify_frame_borders.padding

style notify_text:
    properties gui.text_properties("notify")


## NVL screen ##################################################################
##
## This screen is used for NVL-mode dialogue and menus.
##
## https://www.renpy.org/doc/html/screen_special.html#nvl


screen nvl(dialogue, items=None):

    window:
        style "nvl_window"

        has vbox:
            spacing gui.nvl_spacing

        ## Displays dialogue in either a vpgrid or the vbox.
        if gui.nvl_height:

            vpgrid:
                cols 1
                yinitial 1.0

                use nvl_dialogue(dialogue)

        else:

            use nvl_dialogue(dialogue)

        ## Displays the menu, if given. The menu may be displayed incorrectly if
        ## config.narrator_menu is set to True, as it is above.
        for i in items:

            textbutton i.caption:
                action i.action
                style "nvl_button"

    add SideImage() xalign 0.0 yalign 1.0


screen nvl_dialogue(dialogue):

    for d in dialogue:

        window:
            id d.window_id

            fixed:
                yfit gui.nvl_height is None

                if d.who is not None:

                    text d.who:
                        id d.who_id

                text d.what:
                    id d.what_id


## This controls the maximum number of NVL-mode entries that can be displayed at
## once.
define config.nvl_list_length = gui.nvl_list_length

style nvl_window is default
style nvl_entry is default

style nvl_label is say_label
style nvl_dialogue is say_dialogue

style nvl_button is button
style nvl_button_text is button_text

style nvl_window:
    xfill True
    yfill True

    background "gui/nvl.png"
    padding gui.nvl_borders.padding

style nvl_entry:
    xfill True
    ysize gui.nvl_height

style nvl_label:
    xpos gui.nvl_name_xpos
    # xanchor gui.nvl_name_xalign
    ypos gui.nvl_name_ypos
    # yanchor 0.0
    xsize gui.nvl_name_width
    min_width gui.nvl_name_width
    text_align gui.nvl_name_xalign

style nvl_dialogue:
    xpos gui.nvl_text_xpos
    # xanchor gui.nvl_text_xalign
    ypos gui.nvl_text_ypos
    xsize gui.nvl_text_width
    min_width gui.nvl_text_width
    text_align gui.nvl_text_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_thought:
    xpos gui.nvl_thought_xpos
    # xanchor gui.nvl_thought_xalign
    ypos gui.nvl_thought_ypos
    xsize gui.nvl_thought_width
    min_width gui.nvl_thought_width
    text_align gui.nvl_thought_xalign
    layout ("subtitle" if gui.nvl_text_xalign else "tex")

style nvl_button:
    properties gui.button_properties("nvl_button")
    xpos gui.nvl_button_xpos
    # xanchor gui.nvl_button_xalign

style nvl_button_text:
    properties gui.button_text_properties("nvl_button")



################################################################################
## Mobile Variants
################################################################################

style pref_vbox:
    variant "medium"
    xsize 450

## Since a mouse may not be present, we replace the quick menu with a version
## that uses fewer and bigger buttons that are easier to touch.


style window:
    variant "small"
    background "gui/phone/textbox.png"

style radio_button:
    variant "small"
    foreground "gui/phone/button/check_[prefix_]foreground.png"

style check_button:
    variant "small"
    foreground "gui/phone/button/check_[prefix_]foreground.png"

style nvl_window:
    variant "small"
    background "gui/phone/nvl.png"

style main_menu_frame:
    variant "small"
    background "gui/phone/overlay/main_menu.png"

style game_menu_outer_frame:
    variant "small"
    background "gui/phone/overlay/game_menu.png"

style game_menu_navigation_frame:
    variant "small"
    xsize 340

style game_menu_content_frame:
    variant "small"
    top_margin 0

style pref_vbox:
    variant "small"
    xsize 400

style bar:
    variant "small"
    ysize gui.bar_size
    left_bar Frame("gui/phone/bar/left.png", gui.bar_borders, tile=gui.bar_tile)
    right_bar Frame("gui/phone/bar/right.png", gui.bar_borders, tile=gui.bar_tile)

style vbar:
    variant "small"
    xsize gui.bar_size
    top_bar Frame("gui/phone/bar/top.png", gui.vbar_borders, tile=gui.bar_tile)
    bottom_bar Frame("gui/phone/bar/bottom.png", gui.vbar_borders, tile=gui.bar_tile)

style scrollbar:
    variant "small"
    ysize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/horizontal_[prefix_]bar.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/horizontal_[prefix_]thumb.png", gui.scrollbar_borders, tile=gui.scrollbar_tile)

style vscrollbar:
    variant "small"
    xsize gui.scrollbar_size
    base_bar Frame("gui/phone/scrollbar/vertical_[prefix_]bar.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)
    thumb Frame("gui/phone/scrollbar/vertical_[prefix_]thumb.png", gui.vscrollbar_borders, tile=gui.scrollbar_tile)

style slider:
    variant "small"
    ysize gui.slider_size
    base_bar Frame("gui/phone/slider/horizontal_[prefix_]bar.png", gui.slider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/horizontal_[prefix_]thumb.png"

style vslider:
    variant "small"
    xsize gui.slider_size
    base_bar Frame("gui/phone/slider/vertical_[prefix_]bar.png", gui.vslider_borders, tile=gui.slider_tile)
    thumb "gui/phone/slider/vertical_[prefix_]thumb.png"

style slider_pref_vbox:
    variant "small"
    xsize None

style slider_pref_slider:
    variant "small"
    xsize 600
