﻿init python:
  def phone_gallery_icon_params(scene_id):
    scene=phone_gallery_scenes[scene_id]
    params={}
    params["icon"]=scene["icon"]
    params["caption"]=scene["name"]
    params["page"]=phone_gallery_pages[scene["page"]]
    if renpy.seen_label(scene["unlock_label"]):
      params["action"]=Replay(scene["replay_label"],scope=scene.get("replay_scope",{}),locked=False)
    else:
      params["action"]=None
    params["marked"]="gallery "+scene_id
    params["id"]="gallery "+scene_id
    return params

  def phone_gallery_entries():
    rv=[]
    for scene_id in sorted(phone_gallery_scenes):
      rv.append(phone_gallery_icon_params(scene_id))
    return rv

label phone_app_gallery:
  show suzi idle at tf_phone_suzi_to_right
  with phone_sprite_transition
  menu(screen="phone_icons_choice",initial_items=phone_gallery_entries(),cols=4,id="gallery"):
    "Never mind"("back",extra=True,id="gallery close"):
      $_return="main"
  $renpy.pause(0.5,hard=True)
  return _return

label test_replay:
  scene soccer_bliss
  "replay"
  $renpy.end_replay()
  return
