﻿default phone_app_suzi_chat_unlocked={}

init python:
  def phone_unlock_suzi_chat(chat_id):
    if phone_app_suzi_chat_unlocked.get(chat_id):
      return False
    else:
      phone_app_suzi_chat_unlocked[chat_id]=True
      phone_marked["suzi_chat "+chat_id]=True
      return True

default suzi_chat_id=None

init python:
  def phone_suzi_chat_icon_params(chat_id):
    chat=suzi_chat_entries[chat_id]
    params={}
    params["icon"]=chat["icon"]
    params["caption"]=chat["name"]
    params["page"]=suzi_chat_pages[chat["page"]]
    params["action"]=[SelectedIf(False),SetVariable("suzi_chat_id",chat_id),Jump("phone_app_suzi_chat_do")]
    params["marked"]="suzi_chat "+chat_id
    params["id"]="suzi_chat "+chat_id
    return params

  def phone_suzi_chat_entries():
    rv=[]
    for chat_id in sorted(suzi_chat_entries):
      if phone_app_suzi_chat_unlocked.get(chat_id):
        rv.append(phone_suzi_chat_icon_params(chat_id))
    return rv

label phone_app_suzi_chat:
  show suzi idle at tf_phone_suzi_to_right
  with phone_sprite_transition
  menu(screen="phone_icons_choice",initial_items=phone_suzi_chat_entries(),kind="textbuttons",id="suzi_chat"):
    suzi "Something on your mind?"
    "Never mind"("back",extra=True,id="suzi_chat close"):
      $_return="main"
  $renpy.pause(0.5,hard=True)
  return _return

label phone_app_suzi_chat_do:
  $phone_marked["suzi_chat "+suzi_chat_id]=False
  call expression suzi_chat_entries[suzi_chat_id]["label"] from _call_expression
  return (_return or "suzi_chat")
