﻿## phone messages styles

define message_frame_alpha=0.75

style phone_message_received_frame is frame:
  background Frame(Transform("phone apps texts received_frame",alpha=message_frame_alpha),32,16,16,32)
  padding (8,8,8,25)
  xysize (None,None)
  xalign 0.0

style phone_message_sent_frame is frame:
  background Frame(Transform("phone apps texts sent_frame",alpha=message_frame_alpha),16,16,32,32)
  padding (8,8,8,25)
  xysize (None,None)
  xalign 1.0

style phone_message:
  size 20
  text_align 0.0
  color "#FFF"
  outlines [(1,"#222"),(2,"#2224",1,1)]

## smooth-scroll-to-last-message feature

default phone_messages_vp_status=(None,0.0)

init python:
  class MessagesVPController(renpy.Displayable):
    def render(self,width,height,st,at):
      vp=renpy.get_widget("phone_app_texts_messages","messages_vp")
      if vp:
        adj=vp.yadjustment
        mode,range=store.phone_messages_vp_status
        if range!=adj.range:
          mode="scroll"
          range=adj.range
        if mode=="scroll":
          if adj.value!=adj.range:
            delta=adj.range-adj.value
            adj.change(adj.value+min(max(2.0,delta/10.0),delta))
          else:
            mode=None
        store.phone_messages_vp_status=(mode,range)
      renpy.redraw(self,0)
      return renpy.Render(0,0)

## main messages screen
## can be used with char_id as parameter to show character messages
## or without parameter to show nothing but background
## char_to_object_table is used to convert char_id into actual character object
## if char_id not found in table then char_id is used as character object name directly

screen phone_app_texts_messages(char_id):
  $char=getattr(store,char_id)
  $char_name=str(char)
  ## disable mousewheel rollback while we have scrollable viewport
  ## to still allow rollback during/after phone, keep quick menu with "Back" button visible
  key "mousedown_4" action NullAction()
  key "mousedown_5" action NullAction()
  ## header+content
  side "t c b":
    at tf_phone_app(xpos=300)
    xysize (500,900)
    anchor (0,0.5)
    pos (250,0.5)
    spacing 16
    ## app header
    fixed:
      yfit True
      text "{size=-8}Messages{/}\n[char_name]" xalign 0.5 text_align 0.5
      null height 1
    ## scrollable area with messages
    frame:
      xfill True
      yfill True
      background "#0008"
      padding (32,16,16,16)
      viewport:
        style_prefix "phone"
        id "messages_vp"
        xfill True
        yfill True
        scrollbars "vertical"
        mousewheel True
        pagekeys True
        yinitial 1.0
        vbox:
          xsize 410
          spacing 16
          for message in phone_messages[char_id]["messages"]:
            ## check if message is sent or received
            $message_side="right" if message.startswith(">") else "left"
            $message=message.lstrip(">")
            ## check if message is image
            if message.startswith("$"):
              $message=message.lstrip("$")
              frame:
                if message_side=="left":
                  style "phone_message_received_frame"
                else:
                  style "phone_message_sent_frame"
                imagebutton:
                  idle Transform(message,xsize=350,fit="scale-down")
                  hover Transform(message,xsize=350,fit="scale-down",matrixcolor=BrightnessMatrix(0.15))
                  ## hovered/unhovered are to fix unexpected renpy quirk when hover is stuck
                  hovered Function(do_nothing)
                  unhovered Function(do_nothing)
                  action Show("view_image_full",Dissolve(0.5),message)
            ## check if message is not player choice
            elif not message.startswith("@"):
              frame:
                if message_side=="left":
                  style "phone_message_received_frame"
                else:
                  style "phone_message_sent_frame"
                xmaximum 350
                text message style "phone_message"
    hbox:
      xalign 0.5
      if renpy.get_screen("phone_controller"):
        use phone_icon("back","Back","texts",style_suffix="small",id="messages close")
      else:
        use phone_icon("back","Back",None,style_suffix="small",id="messages close")
  ## smooth-scroll-to-last-message feature
  add MessagesVPController()

label phone_app_texts_messages(char_id):
  show suzi idle at tf_phone_suzi_to_right
  with phone_sprite_transition
  ## unmark messages
  $phone_marked["texts "+char_id]=False
  ## if we have player choice pending, show it
  $_return=None
  show screen phone_app_texts_messages(char_id)
  if phone_messages[char_id]["messages"][-1].startswith("@"):
    call expression phone_messages[char_id]["messages"][-1][1:] from _call_expression_5
  if not _return:
    call screen phone_controller
  hide screen phone_app_texts_messages
  $renpy.pause(0.5,hard=True)
  return _return or "texts"
