﻿transform tf_phone_icon:
  subpixel True
  zoom 0.75
  align (0.5,0.5)
  matrixcolor SaturationMatrix(1.0)
  alpha 1.0
  on idle:
    easein 0.15 zoom 0.75 matrixcolor SaturationMatrix(1.0) alpha 1.0
  on hover:
    easein 0.15 zoom 1.0 matrixcolor SaturationMatrix(1.0) alpha 1.0
  on insensitive:
    easein 0.15 matrixcolor SaturationMatrix(0.0) alpha 0.5

style phone_icon_title:
  layout "nobreak"
  color "#FFF"
  hover_color "#73c2fb" #"#FFA"
  selected_color "#73c2fb" #"#FFA"
  insensitive_color "#FFF8"
  outlines [(2,"#000"),(2,"#0004",1,1),(2,"#0004",2,2)]
  size 24
  text_align 0.5
  anchor (0.5,1.0)
  pos (0.5,1.0)

style phone_icon_title_hud is phone_icon_title:
  size 18
  color "#FFF0"
  outlines [(2,"#0000"),(2,"#0000",1,1),(2,"#0000",2,2)]
  hover_color "#73c2fb" #"#FFA"
  hover_outlines [(2,"#000"),(2,"#0004",1,1),(2,"#0004",2,2)]
  selected_color "#73c2fb" #"#FFA"
  selected_outlines [(2,"#000"),(2,"#0004",1,1),(2,"#0004",2,2)]
  insensitive_color "#FFF0"
  insensitive_outlines [(2,"#0000"),(2,"#0000",1,1),(2,"#0000",2,2)]

#transform tf_phone_icon_small:
#  subpixel True
#  zoom 0.5

style phone_icon_title_small is phone_icon_title:
  size 18

screen phone_icon(icon,caption,action,**kwargs):
  python:
    if isinstance(icon,basestring) and not renpy.has_image(icon,True):
      icon="phone icons "+icon
    caption_style="phone_icon_title"
    style_suffix=kwargs.get("style_suffix","")
    if style_suffix:
      icon_tf=getattr(store,"tf_phone_icon_%s"%style_suffix,None)
      if icon_tf:
        icon=icon_tf(icon)
      if style.exists(caption_style+"_"+style_suffix):
        caption_style=caption_style+"_"+style_suffix
    icon,caption,action=phone_icon_hook(icon,caption,action,**kwargs)
    caption=caption or " "
  fixed:
    fit_first True
    button:
      padding (0,0)
      margin (0,0)
      vbox:
        fixed:
          fit_first True
          xalign 0.5
          add icon at Transform(alpha=0)
          add icon at tf_phone_icon
        text caption style caption_style
      hover_sound "audio/sfx/ui_hover.mp3"
      activate_sound "audio/sfx/ui_click.mp3"
      selected kwargs.get("selected",False)
      if isinstance(action,basestring):
        action Return(action)
      else:
        action action
    if is_phone_marked(kwargs.get("marked","- not marked -")):
      add "phone ui notification" align (1.0,0.0)
