﻿transform tf_phone_app(xpos=200,ypos=100):
  anchor (0.0,0.0)
  pos (xpos,ypos)
  on show:
    xanchor 1.0
    xpos 0
    easein 0.5 xanchor 0.0 xpos xpos
  on hide:
    xanchor 0.0
    xpos xpos
    easeout 0.5 xanchor 1.0 xpos 0

transform tf_phone_app_show_only(xpos=200,ypos=100):
  anchor (0.0,0.0)
  pos (xpos,ypos)
  on show:
    xanchor 1.0
    xpos 0
    easein 0.5 xanchor 0.0 xpos xpos

transform tf_phone_app_hide_only(xpos=200,ypos=100):
  anchor (0.0,0.0)
  pos (xpos,ypos)
  on hide:
    xanchor 0.0
    xpos xpos
    easeout 0.5 xanchor 1.0 xpos 0

screen phone_icons_page(icons,cols=3,row_align=0.5,**kwargs):
  $rows=(len(icons)+cols-1)//cols
  fixed:
    xysize (1100,500)
    vbox:
      align (0.5,0.5)
      spacing 0
      for row in range(0,rows):
        hbox:
          xalign row_align
          spacing 16
          for col in range(0,cols):
            $icon_n=row*cols+col
            if icon_n<len(icons):
              if icons[icon_n].get("visible",True):
                use phone_icon(**icons[icon_n])

style phone_textbutton is textbutton

style phone_textbutton_text is phone_icon_title:
  size 72

screen phone_textbuttons_page(entries,**kwargs):
  fixed:
    xysize (1100,500)
    vbox:
      align (0.5,0.5)
      spacing 16
      for entry in entries:
        fixed:
          fit_first True
          xalign 0.5
          textbutton entry["caption"] action entry["action"] style "phone_textbutton"
          if is_phone_marked(entry.get("marked","- not marked -")):
            add "phone ui notification" anchor (0,0.5) pos (1.0,0.5) offset (16,0)

init python:
  @renpy.pure
  class ScrollPhoneIconsPage(Action,DictEquality):
    def __init__(self, direction):
      super(ScrollPhoneIconsPage,self).__init__()
      self.id="phone_icons_choice_pages"
      self.direction=direction
      self.delay=0.35
    def __call__(self):
      d=renpy.get_widget(None,self.id)
      if d is None:
        raise Exception("There is no displayable with the id {}.".format(self.id))
      adjustment=d.xadjustment
      if int(adjustment.value)%int(adjustment.page)==0:
        if self.direction=="prev":
          if adjustment.value==0:
            amount=adjustment.range
          else:
            amount=-adjustment.page
        else:
          if adjustment.value==adjustment.range:
            amount=-adjustment.range
          else:
            amount=adjustment.page
        if self.delay == 0.0:
          adjustment.change(adjustment.value+amount)
        else:
          adjustment.animate(amount,self.delay,_warper.ease)

style phone_page_title is default:
  color "#FFF"
  outlines [(2,"#000"),(2,"#0004",1,1),(2,"#0004",2,2)]
  text_align 0.5
  xalign 0.5

screen phone_icons_choice(items,**kwargs):
  python:
    app_tf=getattr(store,kwargs.get("app_tf","tf_phone_app"),tf_phone_app)
    choice_id=kwargs.get("id")
    pages={}
    extra_icons=[]
    for sub_items in (kwargs.get("initial_items",[]),items):
      for item in sub_items:
        item_params={}
        item_params["choice_id"]=choice_id
        if isinstance(item,dict):
          item_params.update(item)
        else:
          if len(item.args)>0:
            item_params["icon"]=item.args[0]
          item_params.setdefault("caption",item.caption)
          item_params.setdefault("action",item.action)
          item_params.update(item.kwargs)
        params=item_params.get("params")
        if isinstance(params,basestring):
          params=eval(params)
        if params:
          item_params.update(params)
        if item_params.get("extra",False):
          item_params["small"]=True
          extra_icons.append(item_params)
        else:
          page=item_params.get("page",(1,""))
          page=pages.setdefault(page,[])
          page.append(item_params)
  fixed:
    if app_tf:
      at app_tf
    fit_first True
    vbox:
      xsize 1100
      spacing 16
      viewport:
        id "phone_icons_choice_pages"
        xysize (1100,532)
        fixed:
          xysize (1000*len(pages),532)
          for page_n,page_id in enumerate(sorted(pages)):
            fixed:
              xysize (1100,532)
              xpos 1100*page_n
              vbox:
                align (0.5,0.5)
                text (page_id[1] or "") style "phone_page_title"
                if kwargs.get("kind")=="textbuttons":
                  use phone_textbuttons_page(pages[page_id],**kwargs)
                else:
                  use phone_icons_page(pages[page_id],**kwargs)
      hbox:
        xalign 0.5
        spacing 32
        if len(pages)>1:
          use phone_icon("prev","Prev",ScrollPhoneIconsPage("prev"),style_suffix="small")
        for extra_icon in extra_icons:
          use phone_icon(style_suffix="small",**extra_icon)
        if len(pages)>1:
          use phone_icon("next","Next",ScrollPhoneIconsPage("next"),style_suffix="small")
