﻿init python:
  def custom_phone_show_handler(name,*args,**kwargs):
    if phone_mode:
      if name[0]!="phone":
        img_name=tuple(("phone "+" ".join(name)).split())
        if renpy.has_image(img_name):
          name=img_name
      kwargs["layer"]="phone"
      if name[0]=="phone":
        kwargs["tag"]=name[1]
      renpy.show(name,*args,**kwargs)
    else:
      renpy.show(name,*args,**kwargs)

  def custom_phone_scene_handler(layer="master"):
    if layer in (None,"master") and phone_mode:
      layer="phone"
    renpy.scene(layer)

  def custom_phone_hide_handler(name,layer=None):
    if layer in (None,"master") and phone_mode:
      layer="phone"
    renpy.hide(name,layer)

  config.show=custom_phone_show_handler
  config.scene=custom_phone_scene_handler
  config.hide=custom_phone_hide_handler

  renpy.add_layer("phone",above="master")
  config.context_clear_layers.append("phone")

  def phone_say_attribute_transition_callback(img,mode,before,after):
    if config.tag_layer.get(img)=="phone":
      return (phone_sprite_transition,None)
    else:
      return (config.say_attribute_transition, config.say_attribute_transition_layer)

  config.say_attribute_transition_callback=phone_say_attribute_transition_callback
