﻿## About screen ################################################################
##
## This screen gives credit and copyright information about the game and Ren'Py.
##
## There's nothing special about this screen, and hence it also serves as an
## example of how to make a custom screen.

transform tf_about_button(level=0.25):
  matrixcolor BrightnessMatrix(0)
  on idle:
    easein 0.15 matrixcolor BrightnessMatrix(0)
  on hover:
    easeout 0.15 matrixcolor BrightnessMatrix(level)

screen about_button(img,action,xysize=(300,150),level=0.25):
  if isinstance(action,basestring):
    $action=OpenURL(action)
  button:
    align (0.5,0.5)
    add Transform(img,xysize=xysize,fit="contain") at tf_about_button(level)
    action action

screen about():

    tag menu

    ## This use statement includes the game_menu screen inside this one. The
    ## vbox child is then included inside the viewport inside the game_menu
    ## screen.
    use game_menu(_("About"), scroll="viewport"):

        style_prefix "about"

        vbox:

            label "[config.name!t]" text_size 64 xalign 0.5
            text _("Version [config.version!t]\n") xalign 0.5

            text _("\nYou can support Lockheart through Patreon and SubscribeStar.\n")
            ## TODO: set actual urls
            hbox:
              xalign 0.5
              spacing 64
              use about_button("become_a_patron_button","https://www.patreon.com/keystomylockheart",xysize=(None,100))
              use about_button("subscribestarbutton","https://subscribestar.adult/lockheart",xysize=(None,100))
            text _("\nJoin our Discord and chat with Lockheart directly!\n")
            use about_button("discord","https://discord.gg/S6AtPA2",xysize=(None,100))
            text _("\nAdvanced coding, including the phone mechanic, implimented by Radnor.")

            use about_button("gui/pixiewillow.png","https://twitter.com/_PixieWillow/",xysize=(None,250),level=0.15)
            text _("LewdFX performed by {a=https://twitter.com/_PixieWillow/}@_PixieWillow{/a}. Find her on {a=https://www.patreon.com/PixieWillow}Patreon{/a}.")

            ## gui.about is usually set in options.rpy.
            if gui.about:
                text "[gui.about!t]\n"

            text _("\n\nGame developed using {a=https://www.renpy.org/}Ren'Py{/a} [renpy.version_only].\n\n[renpy.license!t]")

style about_label is gui_label
style about_label_text is gui_label_text
style about_text is gui_text

style about_label_text:
    size gui.label_text_size
