transform animatedZoom(zoomIdle, zoomHover):
    on idle:
        zoom zoomIdle
    on hover:
        linear 0.1 zoom zoomHover

transform pulse:
    matrixcolor BrightnessMatrix(0.0)
    linear 0.7 matrixcolor BrightnessMatrix(0.05)
    linear 0.7 matrixcolor BrightnessMatrix(0.0)
    repeat

image main_menu_background:
    contains:
        "night_sky_bg"
        zoom 0.5

    contains:
        "the_moon"
        zoom 0.4
        transform_anchor True
        anchor (1700,700)
        pos (2121//2,473//2)

    contains:
        subpixel True
        "piano_moon"
        zoom 0.5
        transform_anchor True
        anchor (2121,473)
        pos (2121//2-100,473//2)
        linear 30.0 zoom 0.575
        pause 5.0
        linear 30.0 zoom 0.5
        pause 5.0
        repeat

    contains:
        subpixel True
        "over_the_moon_title"
        zoom 0.25
        anchor (0.5,0.5)
        pos (1640,165)

style main_menu_frame is empty
style main_menu_vbox is vbox
style main_menu_text is gui_text
style main_menu_title is main_menu_text
style main_menu_version is main_menu_text

style main_menu_frame:
    xsize 420
    yfill True

style main_menu_vbox:
    xalign 1.0
    xoffset -30
    xmaximum 1200
    yalign 1.0
    yoffset -30

style main_menu_text:
    properties gui.text_properties("main_menu", accent=True)

style main_menu_title:
    properties gui.text_properties("title")

style main_menu_version:
    properties gui.text_properties("version")

style navigation_mm_button is navigation_button

style navigation_mm_button_text is navigation_button_text:
  xalign 0.5
  text_align 0.5

screen main_menu():
    tag menu

    add gui.main_menu_background

    # imagebutton:
    #     anchor (0.0, 1.0)
    #     action Start("thief")
    #     idle "images/projectb/projectb2.png" at animatedZoom(0.4, 0.425) #####
    #     pos (40, 1020)
    #     hover_sound "audio/sfx/ui_hover.mp3" #
    #     activate_sound "audio/sfx/ui_click.mp3" #

    vbox:
        style_prefix "navigation_mm"

        anchor (0.5,1.0)
        pos (1.0,1.0)
        offset (-285,-135)

        spacing gui.navigation_spacing

        $newest_slot=renpy.newest_slot("[^_]")
        if newest_slot:
          textbutton _("Continue") action [SelectedIf(False),FileLoad(newest_slot,slot=True)]
        textbutton _("Start") action Start()
        textbutton _("Load") action ShowMenu("load")
        textbutton _("Options") action ShowMenu("preferences")
        textbutton _("Support") action ShowMenu("about")

#        if renpy.variant("pc") or (renpy.variant("web") and not renpy.variant("mobile")):
#            ## Help isn't necessary or relevant to mobile devices.
#            textbutton _("Help") action ShowMenu("help")

        if renpy.variant("pc"):
            ## The quit button is banned on iOS and unnecessary on Android and
            ## Web.
            textbutton _("Quit") action Quit(confirm=not main_menu)
