init -100 python:
    scene_switcher_pad = 4
    scene_switcher_dim_x = 128
    scene_switcher_dim_y = 72
    scene_switcher_dim = ( scene_switcher_dim_x, scene_switcher_dim_y)
    scene_switcher_list = None

screen scene_switcher ():
    style_prefix "st_scene_switcher"
    if isinstance (scene_switcher_list, list) and len (scene_switcher_list) > 0:
        vbox:
            for movie_scene in scene_switcher_list:
                button:
                    action [
                        Function (renpy.scene),
                        Function (renpy.show, movie_scene)
                    ]
                    xysize (
                        scene_switcher_dim_x + scene_switcher_pad * 2,
                        scene_switcher_dim_y + scene_switcher_pad * 2
                    )
                    add tf_scene_switcher_button (
                        movie_scene + "_start",
                        scene_switcher_dim
                    )

style st_scene_switcher_frame:
    background None
    anchor (0.5, 0.5)
    padding (0, 0, 0, 0)
    margin (0, 0, 0, 0)
    pos (0.5, 0.5)

style st_scene_switcher_vbox:
    anchor (0.0, 1.0)
    spacing scene_switcher_pad
    pos (0, 1.0)
    offset (10, -10)

style st_scene_switcher_button:
    background "#00000099"
    hover_background "#ffffffbb"
    selected_background "#ffffff66"
    padding (
        scene_switcher_pad,
        scene_switcher_pad,
        scene_switcher_pad,
        scene_switcher_pad
    )