﻿define amob_state_variables=[
  ("persistent.player_name","persistent.player_name","Chester"),
  ("persistent.chester_rel","persistent.chester_rel","Guardian"),
  ("persistent.petal_rel","persistent.petal_rel","ward"),
  ("persistent.rose_rel","persistent.rose_rel","Keeper"),
  ("persistent.girls_rel","persistent.girls_rel","roommate"),
  ("store.titania","titania",False),
  ("store.pridwyn","pridwyn",False),
]

init python:
  def transfer_amob_variables(values):
    for var_name,target_var_name,default_value in amob_state_variables:
      value=values.get(var_name,default_value)
      SetVariable(target_var_name,value)()

label load_amob_state_from_slot(amob_save_slot):
  $transfer_amob_variables(amob_save_page_data.get(amob_save_slot,{}))
  menu:
    myra "State transfered. Do you want to change relationships?"
    "Yes":
      call load_amob_state_relationships from _call_load_amob_state_relationships
    "No":
      pass
  if not titania and not pridwyn:
    menu:
      myra "One more question. Did you decide on Titania or Pridwyn?"
      "Titania":
        $titania=True
        $pridwyn=False
      "Pridwyn":
        $titania=False
        $pridwyn=True
  return

init python:
  def query(title,value,default=None):
    return renpy.input(title,value).strip() or default or value

label load_amob_state_relationships:
  show characters moon at tf_rel_portrait as rel_portrait
  $persistent.chester_rel=query("Who are you to [moon]? (Default is Guardian)",persistent.chester_rel,"Guardian")
  hide rel_portrait

  show characters moon at tf_rel_portrait as rel_portrait
  $persistent.petal_rel=query("Who is [moon] to you? (Default is Ward)",persistent.petal_rel,"ward")
  hide rel_portrait

  show characters rose at tf_rel_portrait as rel_portrait
  $persistent.rose_rel=query("Who is [r] to [moon]? (Default is Keeper)",persistent.rose_rel,"Keeper")
  hide rel_portrait

  show characters bliss at tf_rel_portrait as rel_portrait
  show characters petal at tf_rel_portrait_alt as rel_portrait_alt
  $persistent.girls_rel=query("Who are [b] and [p] to [moon]? (Default is roommate)",persistent.girls_rel,"roommate")
  hide rel_portrait
  hide rel_portrait_alt

  return

label load_default_amob_state:
  $transfer_amob_variables({})
  show characters chester at tf_rel_portrait as rel_portrait
  $persistent.player_name=query("What name do you go by? (Default is Chester)",persistent.player_name,"Chester")
  hide rel_portrait
  myra "Let's define your relationships."
  call load_amob_state_relationships from _call_load_amob_state_relationships_1
  menu:
    myra "One more question. Titania or Pridwyn?"
    "Titania":
      $titania=True
      $pridwyn=False
    "Pridwyn":
      $titania=False
      $pridwyn=True
  return

###############################################################################

init python:
  ## dummy functions/classes to load AMoB saves
  def tf_bg_effect_fn(*args,**kwargs):
    pass

init python:
  import os.path
  import zipfile
  import time

default amob_save_page=1
default amob_save_page_data={}

init python:
  amob_save_page_screenshots={}

style select_amob_save_title:
  color "#FFF"
  outlines [(2,"#000"),(2,"#0004",1,1),(2,"#0004",2,2)]
  xalign 0.5
  text_align 0.5

style select_amob_save_slot_info:
  color "#FFF"
  outlines [(2,"#000"),(2,"#0004",1,1),(2,"#0004",2,2)]
  size 20
  align (0.5,1.0)
  text_align 0.5

style select_amob_save_slot_empty is select_amob_save_slot_info:
  color "#CCC"
  size 24
  align (0.5,0.5)

screen SelectAMoBSave():
  python:
    if amob_save_page=="auto":
      page_title=_("Automatic saves")
    elif amob_save_page=="quick":
      page_title=_("Quick saves")
    else:
      page_title=__("Page {}").format(amob_save_page)
  add "#0008"
  vbox:
    align (0.5,0.5)
    fixed:
      yfit True
      xsize 800
      xalign 0.5
      text "Select A Moment of Bliss save file you want to transfer choices from, continuing where you stopped." style "select_amob_save_title"
    null height 32
    text page_title style "select_amob_save_title"
    null height 16
    grid 3 2:
      xalign 0.5
      spacing 16
      for slot in range(1,6+1):
        python:
          slot_data=amob_save_page_data.get(slot)
          if slot_data:
            slot_time=slot_data["_slot_mtime"]
            format=renpy.translation.translate_string("{#file_time}%Y, %B %d, %H:%M")
            slot_time=_strftime(format,time.localtime(slot_time))
            screenshot=load_amob_screenshot(amob_save_page,slot)
        button:
          xysize (384,216)
          padding (0,0)
          margin (0,0)
          if slot_data:
            add screenshot
            text str(slot_time) style "select_amob_save_slot_info"
            foreground None
            hover_foreground "#FFF4"
          else:
            add "#444"
            text "-EMPTY-" style "select_amob_save_slot_empty"
          action Return(["slot",slot])
    null height 16
    hbox:
      xalign 0.5
      spacing 32
      for page in ("auto","quick",1,2,3,4,5,6,7,8,9):
        textbutton str(page) action [SelectedIf(page==amob_save_page),Return(["page",page])]
    null height 32
    textbutton "Make choices manually" xalign 0.5 action Return("cancel")
  $slot_data=None
  $screenshot=None

init python:
  amob_save_dir="AMomentofBliss-1643306193"

  def load_amob_variables(page,slot,amob_persistent):
    save_path=__import__("__main__").path_to_saves(config.gamedir,amob_save_dir)
    slot_fn="{}-{}{}".format(page,slot,renpy.savegame_suffix)
    full_fn=os.path.join(save_path,slot_fn)
    with zipfile.ZipFile(full_fn,"r") as zf:
      data=zf.read("log")
      slot_data=renpy.loadsave.loads(data)[0]
    rv={}
    rv["_slot_mtime"]=os.path.getmtime(full_fn)
    for var_name,target_var_name,default_value in amob_state_variables:
      if var_name.startswith("persistent."):
        value=getattr(amob_persistent,var_name.partition(".")[2],None)
      else:
        value=slot_data.get(var_name)
      if value is None:
        value=default_value
      rv[var_name]=value
    amob_save_page_data[slot]=rv
    return rv

  def load_amob_screenshot(page,slot):
    screenshot=amob_save_page_screenshots.get(slot)
    if not screenshot:
      save_path=__import__("__main__").path_to_saves(config.gamedir,amob_save_dir)
      slot_fn="{}-{}{}".format(page,slot,renpy.savegame_suffix)
      full_fn=os.path.join(save_path,slot_fn)
      screenshot=renpy.display.im.ZipFileImage(full_fn,"screenshot.png")
      amob_save_page_screenshots[slot]=screenshot
    return screenshot

  def load_amob_save_page(page):
    save_path=__import__("__main__").path_to_saves(config.gamedir,amob_save_dir)
    try:
      with open(os.path.join(save_path,"persistent"),"rb") as f:
        data=f.read()
      data=zipfile.zlib.decompress(data)
      amob_persistent=renpy.loadsave.loads(data)
    except:
      amob_persistent=renpy.persistent.Persistent()
    amob_save_page_data.clear()
    amob_save_page_screenshots.clear()
    for slot in range(1,6+1):
      slot_fn="{}-{}{}".format(page,slot,renpy.savegame_suffix)
      full_fn=os.path.join(save_path,slot_fn)
      try:
        screenshot=load_amob_screenshot(page,slot)
        slot_data=load_amob_variables(page,slot,amob_persistent)
      except:
        screenshot=None
        slot_data=None
      amob_save_page_data[slot]=slot_data
      amob_save_page_screenshots[slot]=screenshot

label select_amob_save:
  $load_amob_save_page(amob_save_page)
  call screen SelectAMoBSave
  $amob_save_page_screenshots.clear()
  if _return=="cancel":
    call load_default_amob_state from _call_load_default_amob_state
  elif _return[0]=="page":
    $amob_save_page=_return[1]
    jump select_amob_save
  else:
    call load_amob_state_from_slot(_return[1]) from _call_load_amob_state_from_slot
  return
