label title_card(headline = config.name, subline = None):
    scene black with dissolve
    pause 0.5

    if headline not in [ None, "" ]:
        show text "{size=*3}[headline]{/size}" as headline at tf_title_card_headline
        pause 2.5
    # showing takes 1.5 seconds plus a pause to let the player assess
    # that there is a title card being shown on the screen

    if subline not in [ None, "" ]:
        show text "{size=*2}[subline]{/size}" as subline at tf_title_card_subline
        pause 3.5
        # same as before with game_title, but with a bit longer to actually grasp
        # the content of the subtitle

    hide headline
    hide subline
    pause 4.0   # hiding takes 3.5 seconds + something to stay at black

    return
